#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Bimbel Easy App', '6285730153434', 'easyapp@gmail.com', 'Jombang, Jawa Timur', 'Logo-1763213475.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (106, 'AHE', '2025-12-28 09:08:18');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (107, 'ASE', '2025-12-28 09:08:41');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (108, 'AGA', '2025-12-28 09:08:46');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (109, 'LET\'S GO', '2025-12-28 09:08:51');


#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=869 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (850, 1, 1559, 109, '500000', 4, 'Aktif', '0000-00-00', '2025-12-28 09:50:23');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (851, 1, 1560, 109, '150000', 28, 'Aktif', '0000-00-00', '2025-12-28 09:52:13');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (852, 1, 1554, 106, '160000', 12, 'Aktif', '0000-00-00', '2025-12-28 09:52:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (853, 1, 1558, 106, '150000', 1, 'Aktif', '0000-00-00', '2025-12-28 09:52:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (854, 1, 1561, 106, '140000', 10, 'Aktif', '0000-00-00', '2025-12-28 09:52:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (855, 1, 1556, 106, '100000', 2, 'Aktif', '0000-00-00', '2025-12-28 09:54:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (856, 1, 1557, 106, '150000', 12, 'Aktif', '0000-00-00', '2025-12-28 09:54:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (857, 1, 1561, 107, '140000', 5, 'Aktif', '0000-00-00', '2025-12-28 09:54:52');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (858, 1, 1562, 106, '185000', 7, 'Lulus', '2025-12-28', '2025-12-28 09:55:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (859, 1, 1555, 106, '150000', 1, 'Aktif', '0000-00-00', '2025-12-28 09:55:14');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (860, 1, 1553, 107, '250000', 28, 'Aktif', '0000-00-00', '2025-12-28 09:55:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (861, 1, 1556, 109, '100000', 5, 'Aktif', '0000-00-00', '2025-12-28 09:56:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (862, 1, 1558, 108, '150000', 5, 'Aktif', '0000-00-00', '2025-12-28 09:57:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (863, 1, 1561, 108, '125000', 7, 'Aktif', '0000-00-00', '2025-12-28 09:57:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (864, 1, 1560, 107, '100000', 4, 'Aktif', '0000-00-00', '2025-12-28 09:57:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (865, 1, 1554, 108, '100000', 29, 'Aktif', '0000-00-00', '2025-12-28 09:57:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (866, 1, 1555, 108, '150000', 1, 'Aktif', '0000-00-00', '2025-12-28 09:57:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (867, 1, 1562, 108, '185000', 7, 'Aktif', '0000-00-00', '2025-12-28 09:58:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (868, 1, 1557, 109, '120000', 12, 'Aktif', '0000-00-00', '2025-12-28 09:58:55');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4686 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4665, 1, '2404:c0:b602:ff62:31cd:a7be:cbfe', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Login', '2025-12-27 19:00:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4666, 1, '2404:c0:b602:ff62:2d6d:5c39:1301', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36', 'Login', '2025-12-27 19:01:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4667, 1, '2404:c0:8ce0::471:f643', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2025-12-28 08:44:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4668, 1, '2001:448a:1149:11e0:c66:8611:9d1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2025-12-28 08:44:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4669, 1, '112.109.18.99', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2025-12-28 08:44:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4670, 1, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Login', '2025-12-28 08:44:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4671, 1, '182.8.182.210', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2025-12-28 08:44:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4672, 1, '103.126.173.27', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2025-12-28 08:45:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4673, 1, '180.251.156.82', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:146.0) Gecko/20100101 Firefox/146.0', 'Login', '2025-12-28 08:45:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4674, 1, '103.155.116.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Mobile Safari/537.36 OPR/93.0.0.0', 'Login', '2025-12-28 08:45:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4675, 1, '36.76.200.51', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2025-12-28 08:45:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4676, 1, '114.10.150.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2025-12-28 08:45:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4677, 1, '157.15.82.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2025-12-28 08:45:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4678, 1, '2001:448a:7140:ae:922:7a96:4c5a:', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2025-12-28 08:46:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4679, 1, '182.8.98.81', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2025-12-28 11:02:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4680, 1, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Logout', '2025-12-28 11:21:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4681, 52, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Login', '2025-12-28 11:21:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4682, 52, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Logout', '2025-12-28 11:28:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4683, 1, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Login', '2025-12-28 11:28:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4684, 1, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Logout', '2025-12-28 11:56:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4685, 1, '2404:c0:b602:ff62:fc5a:73d1:2899', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Login', '2025-12-28 11:56:45');


#
# TABLE STRUCTURE FOR: tb_rekening
#

DROP TABLE IF EXISTS `tb_rekening`;

CREATE TABLE `tb_rekening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namaBank` varchar(10) NOT NULL,
  `noRekening` varchar(20) NOT NULL,
  `pemilik` varchar(50) NOT NULL,
  `terdaftar` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_rekening` (`id`, `namaBank`, `noRekening`, `pemilik`, `terdaftar`) VALUES (42, 'BRI', '76837643648637846736', 'Budi', '2025-12-28 11:38:11');
INSERT INTO `tb_rekening` (`id`, `namaBank`, `noRekening`, `pemilik`, `terdaftar`) VALUES (43, 'BCA', '35435455', 'Adi', '2025-12-28 11:38:31');


#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'demo', '2025-12-28');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1565 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1553, '1624', 'TRI KURNIA SUHARTATI', 'Perempuan', '6282149983840', '2020-10-20', '2025-12-28', '2025-12-28 09:21:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1554, '1', 'Sayuti Wibowo', 'Laki-Laki', '6281213080985', '2020-03-18', '2025-12-01', '2025-12-28 09:22:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1555, '2025001', 'hadriani', 'Perempuan', '6282378956200', '2000-04-02', '2025-01-01', '2025-12-28 09:22:04');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1556, '12345', 'Asti Nidya Agustin', 'Perempuan', '6285735094541', '2018-08-10', '2025-12-01', '2025-12-28 09:22:06');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1557, '4595', 'AMAY LEONY CITRA DEWI', 'Perempuan', '6285961083849', '2017-07-05', '2025-01-12', '2025-12-28 09:22:09');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1558, '01', 'Mike Lugina', 'Perempuan', '628566011988', '2025-06-18', '2025-12-01', '2025-12-28 09:22:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1559, '222', 'Susi', 'Perempuan', '6285335124636', '2024-12-23', '2025-12-30', '2025-12-28 09:22:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1560, '0001', 'yunisa rahmawati', 'Perempuan', '6282176552290', '1988-06-28', '2025-12-28', '2025-12-28 09:22:35');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1561, '10123', 'Lin Sururoh', 'Perempuan', '6281281051568', '2020-09-10', '2025-12-28', '2025-12-28 09:22:53');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1562, '002', 'Mei Yulianita ', 'Perempuan', '6282194838103', '2025-05-27', '2025-12-28', '2025-12-28 09:23:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1563, '01', 'Eka nur hidayah', 'Perempuan', '6285222074349', '2024-12-28', '2025-12-28', '2025-12-28 09:24:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1564, '1', 'xxxxxx', 'Laki-Laki', '6281213080985', '2020-12-22', '2025-01-01', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (101, 1, 12, 2025, '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (102, 1, 12, 2025, '2025-12-28 11:01:58');


#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5165 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5127, 101, 1, 1559, 109, '500000', 4, 'Sudah Bayar', '11:03:00', '2025-12-28', 'Approve', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5128, 101, 1, 1560, 109, '150000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5129, 101, 1, 1554, 106, '160000', 12, 'Sudah Bayar', '10:54:00', '2025-12-28', 'Approve', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5130, 101, 1, 1558, 106, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5131, 101, 1, 1561, 106, '140000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5132, 101, 1, 1556, 106, '100000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5133, 101, 1, 1557, 106, '150000', 12, 'Sudah Bayar', '10:54:00', '2025-12-11', 'Approve', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5135, 101, 1, 1562, 106, '185000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5136, 101, 1, 1555, 106, '150000', 1, 'Sudah Bayar', '10:54:00', '2025-12-16', 'Approve', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5137, 101, 1, 1553, 107, '250000', 28, 'Sudah Bayar', '15:00:00', '2025-12-28', 'Approve', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5138, 101, 1, 1556, 109, '100000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5139, 101, 1, 1558, 108, '150000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5140, 101, 1, 1561, 108, '125000', 7, 'Sudah Bayar', '10:54:00', '2025-12-25', 'Approve', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5141, 101, 1, 1560, 107, '100000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5144, 101, 1, 1562, 108, '185000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 10:18:42');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5146, 102, 52, 1559, 109, '500000', 4, 'Sudah Bayar', '11:26:00', '2025-12-28', 'Approve', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5147, 102, 1, 1560, 109, '150000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5148, 102, 1, 1554, 106, '160000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5149, 102, 1, 1558, 106, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5150, 102, 1, 1561, 106, '140000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5151, 102, 1, 1556, 106, '100000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5152, 102, 1, 1557, 106, '150000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5153, 102, 1, 1561, 107, '140000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5154, 102, 1, 1562, 106, '185000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5155, 102, 1, 1555, 106, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5156, 102, 1, 1553, 107, '250000', 28, 'Sudah Bayar', '11:02:00', '2025-12-28', 'Approve', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5157, 102, 1, 1556, 109, '100000', 5, 'Sudah Bayar', '11:07:00', '2025-12-28', 'Approve', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5158, 102, 52, 1558, 108, '150000', 5, 'Sudah Bayar', '11:22:00', '2025-12-28', 'Approve', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5159, 102, 1, 1561, 108, '125000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5160, 102, 1, 1560, 107, '100000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5161, 102, 1, 1554, 108, '100000', 29, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5162, 102, 1, 1555, 108, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5163, 102, 1, 1562, 108, '185000', 7, 'Sudah Bayar', '11:17:00', '2025-12-28', 'Approve', '2025-12-28 11:01:58');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5164, 102, 1, 1557, 109, '120000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-12-28 11:01:58');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Yaniek Rahayu Isnaningtyas, M.Pd.', 'Perempuan', '6285730153434', 'yaniek.rahayu.isnaningtyas@gmail.com', 'Jombang, Jawa Timur', 'Admin', '$2y$10$rivFp8YP8uy3L.7rfBjr3ONrlNDP2shj/VVDZWeobQGTMgl6c3XY.', 'no-image.png', 'blue', 'Administrator', 'Ya', '2023-05-20 09:36:23');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (52, 'Sayuti Wibowo', 'Laki-Laki', '081213080985', 'easyapp@gmail.com', 'Jombang, Jawa Timur', 'pegawai', '$2y$10$/f5.26VXcS305urSb1dNfe66tTxywWxKVhBGz4CtAC7WXCxUG/S3C', 'no-image.png', 'blue', 'Pegawai', 'Ya', '2025-12-28 08:57:50');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (53, 'Dewi', 'Perempuan', '09098987878', 'yaniek.rahayu.isnaningtyas@gmail.com', 'Jombang, Jawa Timur', 'dewi', '$2y$10$JzHAcqRlDYx/7WZSRnVUJ.cP9YUlqRs01g0SzHyHL3QDRzY/w4uXe', 'no-image.png', 'blue', 'Administrator', 'Ya', '2025-12-28 09:06:24');


